﻿var sortSample = {
    context: $(".v-sort-sample"),
    autocomplete: null,
    initialize: function () {
        var projectId = $("#ProjectId", a4.parent().browse.context).val();

        sortSample.autocomplete = $(".h-sortSampleQuestion").a4autocomplete({
            ajaxAction: a4.getProjectAction("GetBrowseSortSampleQuestions", "Data", { projectId: projectId }),
            valueProperty: "Code",
            labelProperty: "Label",
            altValueField: $("#Variables"),
            maxItems: 3,
            multipleSelection: true,
            hideSelectedItems: true
        });

        var option = $("input[name='BrowseSortEnumValue']:checked").val();
        $("#Questions", sortSample.context).closest(".section").toggleClass("hidden", option == "Random");
    },
    bindEvents: function () {
        sortSample.context.on("change", "input[name='BrowseSortEnumValue']", function () {
            var option = $(this).val();
            var questionsSection = $("#Questions", sortSample.context).closest(".section");

            questionsSection.toggleClass("hidden", option == "Random");
            if (option == "Random")
                sortSample.autocomplete.a4autocomplete("clearValue");
        });
    }
};

$(document).ready(function () {
    if (sortSample.context.length > 0) {
        sortSample.initialize();
        sortSample.bindEvents();
    }
});